-- this file reads preferences and does things with them.

local barLocs = {
	-20,
	-10,
	0,
	10,
	20,
};

local timingScale = {
	1.50,
	1.33,
	1.15,
	1.00,
	0.83,
	0.66,
	0.50,
	0.33,
	0.20,
};

local t = Def.ActorFrame{
	Name="DifficultyIcon";
	InitCommand=cmd(playcommand,"SetFilling");
	SetFillingCommand=function(self)
		for i = 1,5 do
			local bOn = i <= GetLifeDifficulty();
			local lifeBarFill = self:GetChild( "LifeBarFill" .. i );
			lifeBarFill:x(barLocs[i]);
			lifeBarFill:y(2);
			lifeBarFill:zoomto(4,4);
			lifeBarFill:valign(1);
			lifeBarFill:diffuse(color("#000000"));
			lifeBarFill:visible( bOn );
			
			local barFrame = self:GetChild( "LifeBarFrame" .. i );
			lifeBarFrame:x(barLocs[i]);
			lifeBarFrame:y(3);
			lifeBarFrame:zoomto(6,6);
			lifeBarFrame:valign(1);
			lifeBarFrame:diffuse(color("#77777777"));
		end
		--[[
		for i = 1,8 do
			local bOn = timingScale[i] <= math.floor( PREFSMAN:GetPreference('TimingWindowScale') * 100 ) / 100;
			local JudgeBarFill = self:GetChild( "JudgeBarFill" .. i );
			JudgeBarFill:x(barLocs[i]);
			JudgeBarFill:y(-2);
			JudgeBarFill:zoomto(4,4);
			JudgeBarFill:valign(1);
			JudgeBarFill:diffuse(color("#000000"));
			JudgeBarFill:visible( bOn );
			
			local barFrame = self:GetChild( "JudgeBarFrame" .. i );
			JudgeBarFrame:x(barLocs[i]);
			JudgeBarFrame:y(-3);
			JudgeBarFrame:zoomto(6,6);
			JudgeBarFrame:valign(1);
			JudgeBarFrame:diffuse(color("#77777777"));
		end;
		]]
	end;
	
	LoadFont("_frutiger lt std 55 roman 24px") .. {
		InitCommand=cmd(y,-10;settext,"LIFE DIFFICULTY";zoom,0.5;shadowlength,0;diffuse,color("#000000");maxwidth,126;);
	};
};

for i = 1,5 do
	t[#t+1] = Def.Quad{ Name="LifeBarFrame"..i };
	t[#t+1] = Def.Quad{ Name="LifeBarFill"..i };
end;

for i = 1,8 do
	t[#t+1] = Def.Quad{ Name="JudgeBarFrame"..i };
	t[#t+1] = Def.Quad{ Name="JudgeBarFill"..i };
end;

return t